<?php
/* public/config.php */

declare(strict_types=1);

// const API_BASE   = 'http://127.0.0.1:3000';        // ✅ sin comillas extra
const API_BASE   = 'https://api.bmticket.com';       // ✅ sin comillas extra
const API_INIT   = API_BASE . '/api/v1/checkout/init';
const API_CONFIRM = API_BASE . '/api/v1/checkout/confirm';
const API_ORDER_GET = API_BASE . '/api/v1/orders';
const CHECKOUT_BASE = API_BASE . '/checkout';

const USER_JSON_PATH = __DIR__ . '/user.json';

/** Origen donde corre este PHP (para CORS del middleware) */
const API_ORIGIN = 'https://bmticket.com/hondubet-demo/';
// const API_ORIGIN = 'http://localhost:8181';

/** 🔐 Debe coincidir EXACTO con process.env.BMT_API_KEY de Next */
const BMT_API_KEY = 'hbmt_prod_57e7750e4f92f1655bb8';  // <-- pon el valor que quieras, pero igual en Next
const BMT_APP_KEY = 'hbmt_prod_f0a0adb6aed36f97cdc7b97f9c30';  // <-- pon el valor que quieras, pero igual en Next

function http_json_post(string $url, array $payload, int $timeout = 15): array
{
	$ch = curl_init($url);
	$body = json_encode($payload, JSON_UNESCAPED_UNICODE);

	$headers = [
		'Content-Type: application/json',
		'Accept: application/json',
		'Origin: ' . API_ORIGIN,
		'Referer: ' . API_ORIGIN,
		'X-API-Key: ' . BMT_API_KEY,
		'X-App-Key: ' . BMT_APP_KEY, // 👈 añade esto
	];

	curl_setopt_array($ch, [
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_POST           => true,
		CURLOPT_HTTPHEADER     => $headers,
		CURLOPT_POSTFIELDS     => $body,
		CURLOPT_TIMEOUT        => $timeout,
	]);

	$resp = curl_exec($ch);
	$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	$err  = curl_error($ch);
	curl_close($ch);

	if ($resp === false) return ['success' => false, 'message' => "HTTP error: $err", 'http' => $code ?: 0];
	$json = json_decode($resp, true);
	if (!is_array($json)) return ['success' => false, 'message' => 'Respuesta no JSON', 'http' => $code, 'raw' => $resp];
	return $json + ['http' => $code];
}

function http_json_get(string $url, int $timeout = 15): array
{
	$ch = curl_init($url);
	curl_setopt_array($ch, [
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_HTTPGET        => true,
		CURLOPT_HTTPHEADER     => [
			'Accept: application/json',
			'Origin: ' . API_ORIGIN,
			'Referer: ' . API_ORIGIN,
			'X-API-Key: ' . BMT_API_KEY,     // 👈 por si GETs pasan por el middleware
		],
		CURLOPT_TIMEOUT        => $timeout,
	]);
	$resp = curl_exec($ch);
	$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
	$err  = curl_error($ch);
	curl_close($ch);

	if ($resp === false) return ['success' => false, 'message' => "HTTP error: $err", 'http' => $code ?: 0];
	$json = json_decode($resp, true);
	if (!is_array($json)) return ['success' => false, 'message' => 'Respuesta no JSON', 'http' => $code, 'raw' => $resp];
	return $json + ['http' => $code];
}

function load_user(): array
{
	if (!file_exists(USER_JSON_PATH)) return [];
	$raw = file_get_contents(USER_JSON_PATH);
	$j = json_decode($raw, true);
	return is_array($j) ? $j : [];
}


/* ========= Helpers para parsear requests ========= */
function request_data(): array
{
	$raw = file_get_contents('php://input');
	$json = json_decode($raw, true);
	return (is_array($json) && !empty($json)) ? $json : $_POST;
}

function parse_amount($v): float
{
	if (is_numeric($v)) return (float)$v;
	$s = preg_replace('/[^\d,.\-]/', '', (string)$v);
	if (strpos($s, ',') !== false && strpos($s, '.') === false) $s = str_replace(',', '.', $s);
	return (float)$s;
}
