<?php
/* public/crear-orden.php */
declare(strict_types=1);
require __DIR__ . '/config.php';
header('Content-Type: application/json; charset=utf-8');

try {
  $src      = request_data();
  $amount   = parse_amount($src['amount'] ?? 0);
  $currency = strtoupper(trim((string)($src['currency'] ?? 'HNL')));
  if (!in_array($currency, ['HNL','USD','NIO'], true)) $currency = 'HNL';
  $desc     = trim((string)($src['description'] ?? 'Recarga Hondubet'));

  // Min 1 para pruebas
  if ($amount < 1) throw new RuntimeException('Monto inválido');

  $user = load_user();
  $customer = ['name'=>$user['name'] ?? '', 'email'=>$user['email'] ?? ''];
  $billing  = is_array($user['billing'] ?? null) ? $user['billing'] : [];

  $payload = [
    'amount'      => $amount,
    'currency'    => $currency,
    'description' => $desc,
    'customer'    => $customer,
    'billing'     => $billing,
  ];

  // 🚀 Llama a Next con headers (Origin/Referer/X-App-Key)
  $res = http_json_post(API_INIT, $payload);

  if (!($res['success'] ?? false)) {
    http_response_code(400);
    echo json_encode([
      'success' => false,
      'message' => $res['message'] ?? 'Fallo al crear orden',
      'data'    => $res
    ], JSON_UNESCAPED_UNICODE);
    exit;
  }

  $orderId     = $res['order_id'] ?? ($res['order']['order_id'] ?? null);
  $checkoutUrl = $res['checkout_url'] ?? null;

  echo json_encode([
    'success'      => true,
    'order_id'     => $orderId,
    'order'        => $res['order'] ?? null,
    'checkout_url' => $checkoutUrl,
  ], JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
  http_response_code(400);
  echo json_encode(['success'=>false, 'message'=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
}
